; ******************************************************
;       DC mBOT - Connection Manager
; ******************************************************
alias ConMgr { dialog $iif($dialog(ConnectionManager),-v,-m) ConnectionManager ConnectionManager }
alias WriteServ { $iif($3-,.writeini -n,.remini) $DC.Dir(mBOT\Connections.ini) $1 $2 $iif($3-,$3-,) }
alias ReadServ { return $readini($DC.Dir(mBOT\Connections.ini),$1,$iif($2,$2)) }
alias RemServ {
  if ($dialog(ConnectionManager)) && ($1) {
    .remini $DC.Dir(mBOT\Connections.ini) $1
    if ($numtok($ReadServ(List,Value),32) > 1) { .WriteServ List Value $remtokcs($ReadServ(List,Value),$1,0,32) }
    else { .remini $DC.Dir(mBOT\Connections.ini) List Value }
    ServersLoader
  }
}

alias -l NewConnectionStuff {
  if ($1) {
    if ($ReadServ($1,Nickname)) {
      if ($ReadServ($1,Nickname) != $me) { nick $ReadServ($1,Nickname) }
      if ($ReadServ($1,Password)) { $replace($ReadServ($1,NickServ),<Password>,$ReadServ($1,Password)) }
    }
    var %x = 1,%chans = $ReadServ($1,Channels),%chanz,%this
    if (%chans) {
      while (%x <= $numtok(%chans,44)) {
        if ($gettok($gettok(%chans,%x,44),2,58) != $null) {
          %this = $gettok(%chans,%x,44)
          $replace($ReadServ($1,ChanServ),<Channel>,$gettok(%this,1,58),<Password>,$gettok(%this,2,58))
          %chanz = $addtok(%chanz,$gettok(%this,1,58),44)
        }
        else { %chanz = $addtok(%chanz,$gettok(%chans,%x,44),44) }
        inc %x
      }
      if (%chanz) { join %chanz }
      unset %chanz %this
    }
  }
}

alias -l NewConnection {
  if ($1-) { server $1- }
}

alias ConnectionOnOpen {
  if ($ReadServ(List,Value)) {
    var %x = 1,%y = 1,%servs = $ReadServ(List,Value)
    while (%x <= $numtok(%servs,32)) {
      var %serv = $gettok(%servs,%x,32)
      if ($ReadServ($gettok(%servs,%x,32),Auto) == Yes) {
        NewConnection $iif(%y != 1,-m) $+($ReadServ(%serv,Server),:,$iif($ReadServ(%serv,Port),$ifmatch,6667)) $iif($ReadServ(%serv,BNCPassword),$ifmatch)
        inc %y
      }
      inc %x
    }
  }
}

on *:Connect:{
  if ($ReadServ($network,Auto) == Yes) || (%TempConnection. [ $+ [ $network ] ] == Yes) {
    NewConnectionStuff $network
    unset %TempConnection. [ $+ [ $network ] ]
  }
}

alias ServerManager {
  if (!$dialog(ConnectionManager)) return
  dialog $iif($dialog(ServerManager),-v,-m) ServerManager ServerManager
  if ($1) {
    did -b ServerManager 4
    did -ra ServerManager 4 $1
    did -ra ServerManager 6 $ReadServ($1,Server)
    did -ra ServerManager 8 $iif($ReadServ($1,Port),$ifmatch,6667)
    if ($ReadServ($1,Channels)) { did -ra ServerManager 10 $ifmatch }
    if ($ReadServ($1,Nickname)) { did -ra ServerManager 12 $ifmatch }
    if ($ReadServ($1,Password)) { did -ra ServerManager 14 $ifmatch }
    if ($ReadServ($1,Ident)) { did -ra ServerManager 16 $ifmatch }
    if ($ReadServ($1,BNCPassword)) { did -ra ServerManager 18 $ifmatch }
    if ($ReadServ($1,Auto) == 1) { did -c ServerManager 19 }
    if ($ReadServ($1,ChanServ)) { did -ra ServerManager 22 $ifmatch }
    if ($ReadServ($1,NickServ)) { did -ra ServerManager 24 $ifmatch }
    dialog -t ServerManager Edit a Server...
    did -ra ServerManager 28 &Edit
  }
  else {
    did -ra ServerManager 8 6667
    did -ra ServerManager 16 $readini($shortfn($mircdir) $+ mIRC.ini,ident,userid)
    did -ra ServerManager 22 ChanServ identify <Channel> <Password>
    did -ra ServerManager 24 NickServ identify <Password>
  }
}

alias ServersLoader {
  if ($dialog(ConnectionManager)) {
    did -r ConnectionManager 2
    did -b ConnectionManager 4,5,10
    if (!$isfile($DC.Dir(mBOT\Connections.ini))) return
    var %x = 1
    var %y = $numtok($ReadServ(List,Value),32)
    while (%x <= %y) {
      if ($ReadServ($gettok($ReadServ(List,Value),%x,32),Server)) { 
        var %net = $gettok($ReadServ(List,Value),%x,32)
        var %serv = $ReadServ(%net,Server)
        var %port = $ReadServ(%net,Port)
        var %chan = $ReadServ(%net,Channels)
        var %nick = $ReadServ(%net,Nickname)
        var %auto = $iif($ReadServ(%net,Auto) == 1,Yes,No)
        did -a ConnectionManager 2 1 %net $chr(9) $+(%serv,:,%port) $chr(9) %chan $chr(9) %nick $chr(9) %auto
      }
      inc %x
    }
  }
}

dialog ConnectionManager {
  title "Connection Manager [F7]"
  size -1 -1 257 186
  option dbu
  icon $DC.Imgs(Connection.ico)
  box "", 1, 3 30 250 140
  list 2, 6 36 243 117, size extsel
  button "+", 3, 6 156 15 10
  button "-", 4, 22 156 15 10
  button "&Edit", 5, 38 156 35 10
  button "Co&nnect", 10, 74 156 35 10
  button "Clear &All", 6, 208 156 40 10
  button "&Refresh", 7, 167 156 40 10
  button "&Close", 8, 208 173 45 10, cancel
  button "&Help", 9, 3 173 45 10
  list 11, -6 -1 270 30, size
  list 12, 4 4 25 25, size
  text "Connection Manager", 13, 29 3 234 15
  text "Manage each of your Servers, Nicknames, Channels and passwords...", 14, 30 18 233 10
}

on 1:dialog:ConnectionManager:*:*:{
  if ($devent == init) {
    hOS EnableCloseBox $dialog($dname).hwnd true
    MDX MarkDialog $dname
    MDX SetMircVersion $version
    MDX SetBorderStyle $dname 11,12 simple
    MDX SetControlMDX $dname 12 Toolbar flat nodivider wrap list arrows > $Bars
    MDX SetColor $dname 11,12,13,14 background $rgb(199,199,199)
    MDX SetColor $dname 11,12,13,14 textbg $rgb(199,199,199)
    MDX SetColor $dname 11,13 text $rgb(65,141,255)
    MDX SetColor $dname 14 text $rgb(0,0,0)
    MDX SetFont $dname 13 +a 25 700 Ringbearer
    MDX SetFont $dname 14 +a 14 700 Arial
    did -i $dname 12 1 bmpsize 32 32
    did -i $dname 12 1 setimage icon normal $noqt($DC.Imgs(ConSetting.ico))
    did -a $dname 12 +a 1 $chr(9) $+ Connection Manager
    did -b $dname 11,12
    MDX SetControlMDX $dname 2 ListView single report grid rowselect showsel > $Views
    did -i $dname 2 1 HeaderDims 110 135 120 70 45
    did -i $dname 2 1 HeaderText Network $chr(9) Server:Port $chr(9) Channels $chr(9) Nickname $chr(9) Auto?
    ServersLoader
  }
  if ($devent == dclick) {
    if ($did == 2) && ($did(2).sel) { ServerManager $remove($gettok($did(2).seltext,6,32),+fs,$chr(9)) }
  }
  if ($devent == sclick) {
    if ($did == 2) { did $iif(!$did(2).sel,-b,-e) $dname 4,5,10 }
    if ($did == 3) { ServerManager }
    if ($did == 4 && $did(2).sel) {
      var %Result = $input(Are you sure? $+ $crlf $+ You want to remove the selected connection?,wyvg,Confirmation)
      if (%Result == $yes) { RemServ $remove($gettok($did(2).seltext,6,32),+fs,$chr(9)) }
      else { return }
    }
    if ($did == 5 && $did(2).sel) { ServerManager $remove($gettok($did(2).seltext,6,32),+fs,$chr(9)) }
    if ($did == 6) {
      var %Result = $input(Are you sure? $+ $crlf $+ You want to remove all of the connections?,wyvg,Confirmation)
      if (%Result == $yes) { .write -c $DC.Dir(mBOT\Connections.ini) | ServersLoader }
      else { return }
    }
    if ($did == 7) { ServersLoader }
    if ($did == 9) { set %HFile ConMgr | Run_Help }
    if ($did == 10) {
      var %serv = $remove($gettok($did(2).seltext,11,32),+fs,$chr(9))
      var %net = $remove($gettok($did(2).seltext,6,32),+fs,$chr(9))
      set %TempConnection. [ $+ [ %net ] ] Yes
      if ($server) { var %Result = $input(Connect on active window?,qnvg,Confirmation) }
      if (%Result == $yes) && ($server) { disconnect }
      NewConnection $iif(%Result == $no,-m) %serv $iif($ReadServ(%net,BNCPassword),$ifmatch)
    }
  }
}

dialog ServerManager {
  title "Add a new Connection"
  size -1 -1 201 172
  option dbu
  icon $DC.Imgs(Favorites.ico)
  box "Connection", 2, 3 2 195 94
  text "&Network:", 3, 5 11 32 8, right
  edit "", 4, 39 10 90 10, autohs
  text "&Server:", 5, 5 25 32 8, right
  edit "", 6, 39 24 90 10, autohs
  text "P&ort:", 7, 131 25 20 8, right
  edit "", 8, 153 24 40 10, autohs
  text "Channe&l(s):", 9, 5 39 32 8, right
  edit "", 10, 39 38 154 10, autohs
  text "Nic&kname:", 11, 5 53 32 8, right
  edit "", 12, 39 52 55 10, autohs
  text "Pa&ssword:", 13, 106 53 30 8, right
  edit "", 14, 138 52 55 10, autohs
  text "I&dent:", 15, 5 67 32 8, right disable
  edit "", 16, 39 66 55 10, autohs disable
  text "&psyBNC Pass.:", 17, 96 67 40 8, right
  edit "", 18, 138 66 55 10, autohs
  check "A&uto Connect on Startup", 19, 11 81 76 10
  box "Identify Commands", 20, 3 98 195 60
  text "ChanSer&v:", 21, 5 109 32 8, right
  edit "", 22, 39 108 154 10, autohs
  text "N&ickServ:", 23, 5 123 32 8, right
  edit "", 24, 39 122 154 10, autohs
  text "** Tags: <Channel>, <Nick> && <Password>. Read the help section for more information...", 27, 10 138 180 16
  button "&Add", 28, 107 160 45 10
  button "&Cancel", 29, 153 160 45 10, cancel
  button "&Help", 30, 3 160 45 10
}

on 1:dialog:ServerManager:sclick:*:{
  if ($did == 28) {
    if ($istok($ReadServ(List,Value),$did(4),32)) && ($did(28).text != &Edit) { beep 3 | return }
    if (!$did(4) || !$did(6)) { beep 3 | return }
    if (* * iswm $did(4) || * * iswm $did(6) || * * iswm $did(8)) { beep 3 | return }
    .WriteServ List Value $addtok($ReadServ(List,Value),$did(4),32)
    .WriteServ $did(4) Server $did(6)
    .WriteServ $did(4) Port $remove($iif($did(8),$did(8),6667),$chr(32))
    .WriteServ $did(4) Channels $iif($did(10),$did(10))
    .WriteServ $did(4) Nickname $did(12)
    .WriteServ $did(4) Password $did(14)
    .WriteServ $did(4) Ident $did(16)
    if ($did(18)) { .WriteServ $did(4) BNCPassword $did(18) }
    .WriteServ $did(4) Auto $did(19).state
    .WriteServ $did(4) ChanServ $iif($did(22),$did(22),ChanServ identify <Password>)
    .WriteServ $did(4) NickServ $iif($did(24),$did(24),NickServ identify <Password>)
    dialog -c $dname
    if ($dialog(ConnectionManager)) { ServersLoader }
  }
  if ($did == 30) { set %HFile ConMgr | Run_Help }
}
